/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.another_furniture.block;

import com.starfish_studios.another_furniture.block.SeatBlock;
import com.starfish_studios.another_furniture.block.properties.HorizontalConnectionType;
import com.starfish_studios.another_furniture.block.properties.ModBlockStateProperties;
import com.starfish_studios.another_furniture.util.block.HammerableBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BenchBlock
extends SeatBlock
implements SimpleWaterloggedBlock,
HammerableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<HorizontalConnectionType> CONNECTION_TYPE = ModBlockStateProperties.HORIZONTAL_CONNECTION_TYPE_1;
    public static final EnumProperty<HorizontalConnectionType> BACK_TYPE = ModBlockStateProperties.HORIZONTAL_CONNECTION_TYPE_2;
    public static final BooleanProperty BACK = ModBlockStateProperties.BACK;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape AABB_Z = Block.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)7.0, (double)14.0);
    protected static final VoxelShape AABB_X = Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)7.0, (double)16.0);
    protected static final VoxelShape AABB_EAST = Shapes.m_83110_((VoxelShape)AABB_X, (VoxelShape)Block.m_49796_((double)2.0, (double)7.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0));
    protected static final VoxelShape AABB_WEST = Shapes.m_83110_((VoxelShape)AABB_X, (VoxelShape)Block.m_49796_((double)12.0, (double)7.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0));
    protected static final VoxelShape AABB_SOUTH = Shapes.m_83110_((VoxelShape)AABB_Z, (VoxelShape)Block.m_49796_((double)0.0, (double)7.0, (double)2.0, (double)16.0, (double)16.0, (double)4.0));
    protected static final VoxelShape AABB_NORTH = Shapes.m_83110_((VoxelShape)AABB_Z, (VoxelShape)Block.m_49796_((double)0.0, (double)7.0, (double)12.0, (double)16.0, (double)16.0, (double)14.0));

    public BenchBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(CONNECTION_TYPE, (Comparable)((Object)HorizontalConnectionType.SINGLE))).m_61124_(BACK_TYPE, (Comparable)((Object)HorizontalConnectionType.SINGLE))).m_61124_((Property)BACK, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public float seatHeight(BlockState state) {
        return 0.15f;
    }

    @Override
    public BlockPos primaryDismountLocation(Level level, BlockState state, BlockPos pos) {
        return pos.m_121945_((Direction)state.m_61143_((Property)FACING));
    }

    @Override
    public float setRiderRotation(BlockState state, Entity entity) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122435_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (((Boolean)state.m_61143_((Property)BACK)).booleanValue()) {
            return switch (facing) {
                case Direction.EAST -> AABB_EAST;
                case Direction.SOUTH -> AABB_SOUTH;
                case Direction.WEST -> AABB_WEST;
                default -> AABB_NORTH;
            };
        }
        return facing.m_122434_() == Direction.Axis.Z ? AABB_Z : AABB_X;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean waterlogged = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        HorizontalConnectionType connection_type;
        boolean back_r_side;
        Direction facing;
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (direction != (facing = (Direction)state.m_61143_((Property)FACING)).m_122427_() && direction != facing.m_122428_()) {
            return state;
        }
        BlockState l_state = level.m_8055_(currentPos.m_121945_(facing.m_122427_()));
        BlockState r_state = level.m_8055_(currentPos.m_121945_(facing.m_122428_()));
        boolean l_side = l_state.m_60734_() instanceof BenchBlock && (l_state.m_61143_((Property)FACING) == facing || l_state.m_61143_((Property)FACING) == facing.m_122424_());
        boolean r_side = r_state.m_60734_() instanceof BenchBlock && (r_state.m_61143_((Property)FACING) == facing || r_state.m_61143_((Property)FACING) == facing.m_122424_());
        boolean back_l_side = l_state.m_60734_() instanceof BenchBlock && l_state.m_61143_((Property)FACING) == facing && (Boolean)l_state.m_61143_((Property)BACK) != false;
        boolean bl = back_r_side = r_state.m_60734_() instanceof BenchBlock && r_state.m_61143_((Property)FACING) == facing && (Boolean)r_state.m_61143_((Property)BACK) != false;
        HorizontalConnectionType horizontalConnectionType = l_side && r_side ? HorizontalConnectionType.MIDDLE : (r_side ? HorizontalConnectionType.LEFT : (connection_type = l_side ? HorizontalConnectionType.RIGHT : HorizontalConnectionType.SINGLE));
        HorizontalConnectionType back_type = back_l_side && back_r_side ? HorizontalConnectionType.MIDDLE : (back_r_side ? HorizontalConnectionType.LEFT : (back_l_side ? HorizontalConnectionType.RIGHT : HorizontalConnectionType.SINGLE));
        return (BlockState)((BlockState)state.m_61124_(CONNECTION_TYPE, (Comparable)((Object)connection_type))).m_61124_(BACK_TYPE, (Comparable)((Object)back_type));
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.tryHammerBlock((Property)BACK, state, (LevelAccessor)level, pos, player, hand)) {
            return InteractionResult.SUCCESS;
        }
        if (hand == InteractionHand.MAIN_HAND) {
            return InteractionResult.FAIL;
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, CONNECTION_TYPE, BACK_TYPE, BACK, WATERLOGGED});
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Override
    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }
}

